/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid.ranged;

import dev.xkmc.mob_weapon_api.api.projectile.BowUseContext;
import dev.xkmc.mob_weapon_api.api.projectile.IBowBehavior;
import dev.xkmc.mob_weapon_api.api.projectile.ProjectileWeaponUser;
import dev.xkmc.mob_weapon_api.registry.WeaponRegistry;
import dev.xkmc.modulargolems.content.entity.goals.GolemMeleeGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.ranged.GolemRangedAttackGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.ranged.GolemUser;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class GolemBowAttackGoal
extends GolemRangedAttackGoal {
    private int attackTime = -1;

    public GolemBowAttackGoal(HumanoidGolemEntity mob, GolemMeleeGoal melee, double speed, double radius) {
        super(mob, melee, speed, radius);
    }

    @Override
    public boolean mayActivate(HumanoidGolemEntity golem, ItemStack stack) {
        Optional weapon = WeaponRegistry.BOW.get((LivingEntity)this.mob, stack);
        if (weapon.isEmpty()) {
            return false;
        }
        return ((IBowBehavior)weapon.get()).hasProjectile((ProjectileWeaponUser)new GolemUser(this.mob, null), stack);
    }

    @Override
    public void m_8041_() {
        this.attackTime = -1;
    }

    public void m_8037_() {
        this.doMelee();
        this.strafing();
        LivingEntity target = this.mob.m_5448_();
        if (this.mob.m_6117_() && target != null) {
            GolemUser user = new GolemUser(this.mob, target);
            double dist = this.mob.m_20270_((Entity)target);
            if (this.seeTime < -60) {
                this.mob.m_5810_();
            } else if (this.seeTime > 0) {
                ItemStack stack = this.mob.m_21211_();
                Optional weapon = WeaponRegistry.BOW.get((LivingEntity)this.mob, stack);
                int i = this.mob.m_21252_();
                if (weapon.isPresent()) {
                    int pullTime = ((IBowBehavior)weapon.get()).getPreferredPullTime((BowUseContext)user, stack, dist);
                    if (i >= pullTime) {
                        this.mob.m_6504_(target, ((IBowBehavior)weapon.get()).getPowerForTime((BowUseContext)user, stack, i));
                        this.mob.m_5810_();
                        this.attackTime = 10;
                    } else {
                        ((IBowBehavior)weapon.get()).tickUsingBow((ProjectileWeaponUser)user, stack);
                    }
                }
            }
        } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
            this.mob.m_6672_(this.mob.getWeaponHand());
            ItemStack stack = this.mob.m_21211_();
            Optional weapon = WeaponRegistry.BOW.get((LivingEntity)this.mob, stack);
            GolemUser user = new GolemUser(this.mob, target);
            weapon.ifPresent(e -> e.startUsingBow((ProjectileWeaponUser)user, stack));
        }
    }

    @Override
    public void performRangedAttack(HumanoidGolemEntity golem, LivingEntity target, float power, ItemStack stack, InteractionHand hand) {
        WeaponRegistry.BOW.get((LivingEntity)golem, stack).ifPresent(e -> e.shootArrow((BowUseContext)new GolemUser(golem, target), power, stack, hand));
    }
}

